import numpy as np


def get_individual_regret(regret_lists):
    regret_mean = np.mean(regret_lists, axis=0)
    agent_id = np.argmax(regret_mean[:, -1])
    individual_regret = regret_lists[:, agent_id, :]
    individual_regret_std = np.std(individual_regret, axis=0)
    individual_regret_mean = np.mean(individual_regret, axis=0)
    return individual_regret_mean, individual_regret_std

def get_group_regret(regret_lists):
    group_regret = np.sum(regret_lists, axis=1)
    group_regret_mean = np.mean(group_regret, axis=0)
    group_regret_std = np.std(group_regret, axis=0)
    return group_regret_mean, group_regret_std

def get_comm_mean_std(comm):
    return np.mean(comm, axis=0), np.std(comm, axis=0)

def merge_comm(result_lists):
    min_len = min(res.shape[2] for res in result_lists)
    trimmed = [res[:, :, :min_len] for res in result_lists]
    return np.concatenate(trimmed, axis=0)

def merge_comm(result_lists):
    min_len = int(min(min(res.shape[1] for res in result_lists), 1e6))
    print(min_len)
    trimmed = [res[:, :min_len] for res in result_lists]
    return np.concatenate(trimmed, axis=0)

def get_regret_mean_std(regret_lists):
    regret_mean = np.mean(regret_lists, axis=0)
    regret_std = np.std(regret_lists, axis=0)
    return regret_mean, regret_std